function cdx_new = merge_CDX_data_citi(CDX1, CDX2)
% Impute the data from CDX2 into CDX1, unless already available

if ~isfield(CDX1, 'delta_tr_idx_GC')
    CDX1.delta_tr_idx_GC = {[] [] []};
    CDX1.delta_tr_idx_GC{1} = zeros(length(CDX1.dates{1}), 5);
    CDX1.delta_tr_idx_GC{2} = zeros(length(CDX1.dates{2}), 5);
    CDX1.delta_tr_idx_GC{3} = zeros(length(CDX1.dates{3}), 5);
end

% General cases
for j=1:length(CDX2.dates)
    % Insert index price data (if price == 0)
    dates = CDX1.dates{j};
    dates2 = CDX2.dates{j};
    for i=1:length(dates)
        % Determine matching date
        date = dates(i);
        [ind, pos] = is_member_sorted_c(date, dates2);
        if (pos == 0)
            continue;
        end    
        % Insert Index prices
        if (CDX1.index_market_price{j}(i) == 0)
            CDX1.index_market_price{j}(i) = CDX2.index_market_price{j}(pos);
        end
        % Insert GC deltas
        if (CDX1.delta_tr_idx_GC{j}(i) == 0)
            CDX1.delta_tr_idx_GC{j}(i,:) = CDX2.delta_tr_idx_GC{j}(pos,:);
        end
    end
end

% Special case1: 5Y prices on 01-Sept-2006 seem to be off
pos_old = find(CDX1.dates{1} == datenum('09/01/2006'));
pos_new = find(CDX2.dates{1} == datenum('09/01/2006'));
if (~isempty(pos_old) & ~isempty(pos_new))
    CDX1.tranche_market_upfront_mid{1}(pos_old,:) = CDX2.tranche_market_upfront_mid{1}(pos_new,:);
    CDX1.tranche_market_price_mid{1}(pos_old,:) = CDX2.tranche_market_price_mid{1}(pos_new,:);
    CDX1.T{1}(pos_old) = max(CDX1.T{1}(pos_old), CDX2.T{1}(pos_new));
end

% Special case3: 5Y prices on 05-Jul-2005 seem to be off for senior tranche
pos_old = find(CDX1.dates{1} == datenum('07/05/2005'));
pos_new = find(CDX2.dates{1} == datenum('07/05/2005'));
if (~isempty(pos_old) & ~isempty(pos_new))
    CDX1.tranche_market_upfront_mid{1}(pos_old,4) = CDX2.tranche_market_upfront_mid{1}(pos_new,4);
    CDX1.tranche_market_price_mid{1}(pos_old,4) = CDX2.tranche_market_price_mid{1}(pos_new,4);
    CDX1.T{1}(pos_old) = max(CDX1.T{1}(pos_old), CDX2.T{1}(pos_new));
end
cdx_new = CDX1;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Append CDX2 data, if it is more recent than CDX1 %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

for j=1:length(CDX1.dates)
    % Determine additional available dates
    additional_dates = find(CDX2.dates{j} > CDX1.dates{j}(end));
    if (isempty(additional_dates))
        continue;
    end
    
    % Copy additional data from CDX2 to CDX1
    CDX1.dates{j} =                      [CDX1.dates{j}; CDX2.dates{j}(additional_dates)];
    CDX1.T{j} =                          [CDX1.T{j}; CDX2.T{j}(additional_dates)];
    CDX1.index_market_price{j} =         [CDX1.index_market_price{j}; CDX2.index_market_price{j}(additional_dates)];
    CDX1.tranche_market_price_mid{j} =   [CDX1.tranche_market_price_mid{j}; CDX2.tranche_market_price_mid{j}(additional_dates,:)];
    CDX1.tranche_market_upfront_mid{j} = [CDX1.tranche_market_upfront_mid{j}; CDX2.tranche_market_upfront_mid{j}(additional_dates,:)];    
    CDX1.delta_tr_idx_GC{j} =            [CDX1.delta_tr_idx_GC{j}; CDX2.delta_tr_idx_GC{j}(additional_dates,:)];
end
CDX1.index_members = [CDX1.index_members; zeros(length(additional_dates), length(CDX1.portfolio))];

